package IMPL::Web::PreconditionException;
use strict;

use IMPL::declare {
    base => {
        'IMPL::Web::Exception' => '@_'
    }
};

use IMPL::Resources::Strings {
    message => "Precondition Failed"
};

sub status {
    "412 Precondition Failed"
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::PreconditionException> - The precondition given in one or more of
the request-header fields evaluated to false when it was tested on the server.

This response code allows the client to place preconditions on the current
resource metainformation (header field data) and thus prevent the requested
method from being applied to a resource other than the one intended.

=cut