package IMPL::Web::Application::Action;
use strict;

use base qw(IMPL::Object);

use IMPL::Class::Property;

BEGIN {
	public property application => prop_get | owner_set;
	public property request => prop_get | owner_set;
	public property response => prop_get | owner_set;
	
	private property _entryPoint => prop_all;
}

sub Invoke {
	my ($this) = @_;
	
	if ($this->_entryPoint) {
		$this->_entryPoint->();
	} else {
		die new IMPL::InvalidOperationException("At least one handler is required");
	}
}

sub ChainHandler {
	my ($this,$handler) = @_;
	
	my $delegate;

	my $delegateNext = $this->_entryPoint();
	
	if (ref $handler eq 'CODE') {
		$delegate = sub {
			$handler->($this,$delegateNext);			
		};
	} elsif (UNIVERSAL::isa($handler,'IMPL::Web::Application::QueryHandler')) {
		$delegate = sub {
			$handler->Invoke($this,$delegateNext);
		}
	} else {
		die new IMPL::InvalidArgumentException("An invalid handler supplied");
	}
	
}

1;

__END__

=pod

=head1 DESCRIPTION

   ,  ,  .

   ,   C<IMPL::Web::Application::UriController>.
     ,       ,
             ,
   .

    ,   

$objSecCallToMethod($target,$method)
$AuthenticateMethod
$TDocumentOut($file)

    

Action->Invoke() {
	TDocumentOut->Invoke($Action,$nextHandler) {
		my $result = $nextHandler() {
			$AuthenticateMethod($Action,$nextHandler) {
				my $context = $Action->application->security->Authenticate($Action->request,$Action->response);
				return $context->Impersonate($nextHandler) {
					$objSecCallToMethod->Invoke($Action,undef) {
						IMPL::Security->AccessCheck($target,$method);
						return $target->$method();
					}
				}
			}
		}
		$this->format($result,$Action->response->streamBody);
	}		
}

     

$objSecCallToMethod($target,$method)
$AuthenticateMethod
$TransfromToSimpleData
$JSONOut

      ,     
     JSON .    
     ,     .

=cut