package IMPL::Test::HarnessRunner;
use strict;
use warnings;

use base qw(IMPL::Object IMPL::Object::Autofill IMPL::Object::Serializable);
use IMPL::Class::Property;
use Test::Harness;

__PACKAGE__->PassThroughArgs;

BEGIN {
    public property Strap => prop_all;
}

sub CTOR {
    my $this = shift;
    
    die new IMPL::InvalidArgumentException("The Strap parameter must be specified") unless $this->Strap;
}

sub RunTests {
    my ($this,@files) = @_;
    
    local $Test::Harness::Strap = $this->Strap;
    
    return runtests(@files);
}

sub ExecuteTests {
    my ($this,%args) = @_;
    
    local $Test::Harness::Strap = $this->Strap;
    
    return Test::Harness::execute_tests(%args);
}

1;
