package IMPL::Web::Application::HttpResponseResource;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		HttpResponse => 'IMPL::Web::HttpResponse'
	},
	base => [
		'IMPL::Object' => undef,
		'IMPL::Web::Application::ResourceInterface' => undef
	],
	props => [
		response => PROP_RW
	]
};

sub CTOR {
	my ($this,%args) = @_;
	
	$this->response($args{response} || HttpResponse->NoContent);
}

sub FetchChildResource {
	return shift;
}

sub InvokeHttpVerb {
	return shift->response;
}

1;