package IMPL::SQL::Schema::Type;
use strict;
use warnings;

use IMPL::lang qw( :compare );
use IMPL::Const qw(:prop :access);
use IMPL::declare{
    base => [
        'IMPL::Object' => undef,
    ],
    props => [
        name => PROP_RO | PROP_DIRECT,
        maxLength => PROP_RO | PROP_DIRECT,
        scale => PROP_RO | PROP_DIRECT,
        unsigned => PROP_RO | PROP_DIRECT,
        zerofill => PROP_RO | PROP_DIRECT,
        tag => PROP_RO | PROP_DIRECT
    ]
};

sub CTOR {
    my $this = shift;
    
    my $fields = ref($_[0]) eq 'HASH' ? $_[0] : { @_ };
    
    while(my ($k,$v) = each %$fields) {
    	$this->$k($v);
    }
    
    $this->{$scale} = 0 if not $this->{$scale};
}

sub SameValue {
    my ($this,$other) = @_;
    
    return (
        $this->{$name} eq $other->name
        and equals($this->{$maxLength},$other->{$maxLength})
        and equals($this->{$scale},$other->{$scale})
    );
}

1;

__END__

=pod

=head1 NAME

C<IMPL::SQL::Schema::Type> Описывает SQL типы данных

=head1 SYNOPSIS

=begin code

use IMPL::SQL::Schema::Type;

my $varchar_t = new IMPL::SQL::Schema::Type( name => 'varchar', maxLength => 255 );

my $real_t = new IMPL::SQL::Schema::Type( name => 'float', maxLength=> 10, scale => 4); # mysql: float(10,4)

=end

Данный класс используется для стандатрного описания SQL типов данных. В зависимости
от движка БД эти объекты могут быть представлены различными строковыми представлениями. 

=head1 MEMBERS

=over

=item C<CTOR(%props)>

Конструктор, заполняет объект значениями которые были переданы в конструкторе.

=item C<[get]name>

Имя типа. Обязательно.

=item C<[get]maxLength>

Максимальная длина, используется только для типов, имеющих длину (либо переменную,
либо постоянную).

=item C<[get]scale>

Точность, количество знаков после запятой. Используется вместе с C<maxLength>.

=item C<[get]unsigned>

Используется с числовыми данными, обозначает беззнаковые типы.

=item C<[get]zerofill>

Нестандартный атрибут дополняющий числа лидирующими нулями до C<maxLength>.

=item C<[get]tag>

Хеш с дополнительными опциями.

=back

=cut
