package IMPL::Web::UnsupportedMediaException;
use strict;

use IMPL::declare {
    base => {
        'IMPL::Web::Exception' => '@_'
    }
};

sub status {
    "415 Unsupported Media Type"
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::UnsupportedMediaException> - 415 Unsupported Media Type

=head1 DESCRIPTION

The request entity has a media type which the server or resource does not
support. For example, the client uploads an image as C<image/svg+xml>, but the
server requires that images use a different format.
L<http://en.wikipedia.org/wiki/List_of_HTTP_status_codes>

=cut