package IMPL::DOM::Schema::SimpleNode;
use strict;
use warnings;

use base qw(IMPL::DOM::Schema::Node);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
	public _direct property inflator => prop_get;
	public _direct property messageInflateError => prop_get;
}

our %CTOR = (
    'IMPL::DOM::Schema::Node' => sub {
    	my %args = @_;
    	$args{nodeName} ||= 'SimpleNode';
    	delete @args{qw(inflator messageInflateError)};
    	%args
    }
);

sub CTOR {
	my ($this,%args) = @_;
	
	$this->{$inflator} = $args{inflator} if $args{inflator};
	$this->{$messageInflateError} = $args{messageInflateError} || 'Failed to inflate nodeValue %Node.path%: %Error%';
}

sub Validate {
    my ($this,$node,$ctx) = @_;
    
    my @result;
    
    push @result, $_->Validate($node,$ctx) foreach $this->childNodes;
    
    return @result;
}

sub inflateValue {
	my ($this,$value) = @_;
	
	if ( my $inflator = $this->inflator ) {
		return $inflator->new($value);
	} else {
		return $value;
	}
}

1;

__END__

=pod

=head1 NAME

C<IMPL::DOM::SimpleNode> -   .

=head1 DESCRIPTION

   .     
  .

  ,   DOM    
      C<IMPL::DOM::Node>.

        DOM .

=cut
