package Schema::Form::Container;
use Form::Container;
use Common;
use parent qw(Schema::Form::Item);

BEGIN {
    DeclareProperty Children => ACCESS_READ;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->SUPER::CTOR(@args{qw(Name isMulti Filters)});
    
    $this->{$Children} = [];
    
}

sub AddChild {
    my ($this,$child) = @_;
    
    not grep { $_->Name eq $child->Name } $this->Children or die new Exception("The item already exists",$child->Name);
    
    push @{$this->{$Children}},$child;
}

sub FindChild {
    my ($this,$name) = @_;
    
    my @result = grep { $_->Name eq $name} $this->Children;
    return $result[0];
}

sub Dispose {
    my ($this) = @_;
    
    delete $this->{$Children};
    
    $this->SUPER::Dispose;
}
1;
