package Form::ValueItem::List;
use Common;
use parent qw(Form::ValueItem);

BEGIN {
    DeclareProperty ListValues => ACCESS_READ;
    DeclareProperty CurrentItem => ACCESS_READ;
}

sub CTOR {
    my $this = shift;
    $this->SUPER::CTOR(@_);
    
    $this->{$ListValues} = [];
    
    my $source = $this->Form->Bindings->{$this->Attributes->{source}};
    
    if (ref $source eq 'CODE') {
        $this->LoadList($source->());
    } elsif (ref $source and (UNIVERSAL::isa($source,'HASH') or UNIVERSAL::isa($source,'ARRAY'))){
        $this->LoadList($source);
    } else {
        if (not $source) {
            warn "a source isn't specified for the listvalue ".$this->Id->Canonical;
        } else {
            warn "an unsupported source type ".(ref $source)." for the listvalue".$this->Id->Canonical;
        }
    }
}

sub Value {
    my $this = shift;
    
    if (@_) {
        my $newValue = shift;
        
        $this->{$CurrentItem}->{active} = 0 if $this->{$CurrentItem};
        
        my ($item) = (defined $newValue ? grep {defined $_->{id} and $_->{id} eq $newValue} @{$this->{$ListValues}} : undef);
        
        if ($item) {
            $this->{$CurrentItem} = $item;
            $item->{active} = 1;
            return $this->SUPER::Value($newValue);
        } else {
            undef $this->{$CurrentItem};
            return $this->SUPER::Value(undef);
        }
    } else {
        return $this->SUPER::Value;
    }
}

sub LoadList {
    my ($this,$refList) = @_;
    
    if (ref $refList and UNIVERSAL::isa($refList,'HASH')) {
        $this->{$CurrentItem} = undef;
        $this->{$ListValues} = [ sort { $a->{name} cmp $b->{name} } map { Form::ValueItem::List::Item->new($_,ref $refList->{$_} eq 'ARRAY' ? @{$refList->{$_}} : $refList->{$_})} keys %{$refList}];
        $this->SUPER::Value(undef);
    } elsif (ref $refList and UNIVERSAL::isa($refList,'ARRAY')) {
        $this->{$CurrentItem} = undef;
        $this->{$ListValues} = [map { Form::ValueItem::List::Item->new(ref $_ eq 'ARRAY' ? @$_ : $_ )} @$refList];
        $this->SUPER::Value(undef);
    } else {
        die new Exception('An unexpected list type');
    }
}

package Form::ValueItem::List::Item;
use fields qw(
    id
    description
    name
    active
);

sub new {
    my ($class,$id,$name,$desc) = @_;
    
    my $this=fields::new($class);
    $this->{id} = $id;
    $this->{name} = $name;
    $this->{description} = $desc;
    
    return $this;
}

#compatibility with TToolkit

sub Id {
    $_[0]->{id};
}

sub Description {
    $_[0]->{description};
}

sub Active {
    $_[0]->{active};
}

sub Name {
    $_[0]->{name};
}

1;
