package IMPL::DOM::Transform::QueryToDOM;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	base => [
	   'IMPL::DOM::Transform::ObjectToDOM' => '@_'
	],
	props => [
	   prefix => PROP_RO,
	   delimier => PROP_RO
	]
};

sub CTOR {
	my ($this) = @_;
	
	$this->templates->{'CGI'} = \&TransformCGI;
	$this->templates->{'CGIWrapper'} = \&TransformCGI;
	
	$this->delimier('.');
}

sub TransformCGI {
	my ($this,$query) = @_;

    my $data={};
    
    my $prefix = $this->prefix;
    my $delim = $this->delimiter;
    
    foreach my $param (grep index($_,$prefix) >= 0 , $query->param()) {
        length (my $value = $query->param($param)) or next;
        
        my @parts = split /\//,$param;
        
        my $node = $data;
        while ( my $part = shift @parts ) {
            if (@parts) {
                $node = ($node->{$part} ||= {});
            } else {            
                $node->{$part} = $value;
            }
        }  
    }
    
    if (keys %$data > 1) {
        $data = { document => $data };
    }
    
    return $this->Transform($data);
}