package IMPL::DOM::Schema::ComplexType;
use strict;
use warnings;

use parent qw(IMPL::DOM::Schema::ComplexNode);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
use IMPL::DOM::Property qw(_dom);

BEGIN {
    public _dom _direct property nativeType => prop_get;
    public _dom _direct property messageWrongType => prop_get;
}

our %CTOR = (
    'IMPL::DOM::Schema::ComplexNode' => sub {
        my %args = @_;
        $args{nodeName} ||= 'ComplexType';
        $args{minOccur} = 0;
        $args{maxOccur} = 'unbounded';
        $args{name} ||= 'ComplexType';
        delete @args{qw(nativeType messageWrongType)};
        %args
    }
);

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$nativeType} = $args{nativeType};
    $this->{$messageWrongType} = $args{messageWrongType} || "A complex node '%Node.path%' is expected to be %Schema.nativeType%";
}

sub Validate {
    my ($this, $node,$ctx) = @_;
    
    if ($this->{$nativeType}) {
        return new IMPL::DOM::Schema::ValidationError(
            node => $node,
            source => $ctx->{Source} || $this,
            schema => $this,
            message => $this->messageWrongType
        ) unless $node->isa($this->{$nativeType});
    }
    return $this->SUPER::Validate($node,$ctx);
}

sub qname {
    $_[0]->nodeName.'[type='.$_[0]->type.']';
}


1;
