package IMPL::DOM::Schema::NodeSet;
use strict;
use warnings;

use base qw(IMPL::DOM::Schema::Item);
use IMPL::Class::Property;

BEGIN {
    public property UnexpectedMessage => prop_all;
    public property MaxMessage => prop_all;
    public property MinMessage => prop_all;
}

sub Validate {
    my ($this,$node) = @_;
    
    my @errors;
    
    my %nodes = map {
        $_->nodeName ,
        {Schema => $_, Min => $_->minOccur, Max => $_->maxOccur, Seen => 0 }
    } @{$this->childNodes};
    
    foreach my $child ( @{$node->childNodes} ) {
        if (my $info = $nodes{$child->nodeName}) {
            $info->{Seen}++;
            push @errors,{
                Error => 1,
                Source => $this,
                Node => $child,
                Message => $this->MaxMessage
            } if ($info->{Seen} > $info->{Max});
            
            push @errors,$info->{Schema}->Validate($child);
        } else {
            push @errors, {
                Error => 1,
                Source => $this,
                Node => $child,
                Message => $this->UnexpectedMessage
            }
        }
    }
    
    foreach my $info (values %nodes) {
        push @errors, {
            Error => 1,
            Source => $this,
            Message => $this->MinMessage
        } if $info->{Min} > $info->{Seen};
    }
    
    return @errors;
}

1;

__END__

=pod

=head1 DESCRIPTION

   .   .    
 C<IMPL::DOM::Schema::ComplexNode>  C<IMPL::DOM::Schema::SimpleNode>.

   ,      
  ,     
  .

=cut
