package IMPL::DOM::Schema::ComplexType;
use strict;
use warnings;

use IMPL::declare {
	base => [
		'IMPL::DOM::Schema::ComplexNode' => sub {
	        my %args = @_;
	        $args{nodeName} ||= 'ComplexType';
	        $args{minOccur} = 0;
	        $args{maxOccur} = 'unbounded';
	        $args{name} ||= 'ComplexType';
	        delete @args{qw(nativeType messageWrongType)};
	        %args
	    }
	],
	props => [
		nativeType => { get => 1, set => 1, direct => 1, dom => 1 },
		messageWrongType => { get => 1, set => 1, direct => 1, dom => 1 }
	]
};

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$nativeType} = $args{nativeType};
    $this->{$messageWrongType} = $args{messageWrongType} || "A complex node '%node.path%' is expected to be %schema.nativeType%";
}

sub Validate {
    my ($this, $node,$ctx) = @_;
    
    if ($this->{$nativeType}) {
        return new IMPL::DOM::Schema::ValidationError(
            node => $node,
            schemaNode => $ctx->{schemaNode} || $this,
            schemaType => $this,
            message => $this->messageWrongType
        ) unless $node->isa($this->{$nativeType});
    }
    
    return $this->SUPER::Validate($node,$ctx);
}

sub qname {
    $_[0]->nodeName.'[type='.$_[0]->type.']';
}


1;
