package IMPL::SQL::Schema::MySQL::CharType;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
    require => {
        Exception => 'IMPL::Exception',
        ArgException => '-IMPL::InvalidArgumentException'        
    },
    base => [
        'IMPL::SQL::Schema::Type' => '@_'
    ],
    props => [
        encoding => PROP_RO
    ]
};

my @CHAR_TYPES = qw(VARCHAR CHAR);

sub CTOR {
    my ($this) = @_;
    
    die ArgException->new(name => "The specified name is invalid", $this->name)
        unless grep uc($this->name) eq $_, @CHAR_TYPES;
}

1;