package IMPL::Class::MemberInfo;
use strict;
use parent qw(IMPL::Object::Accessor);

require IMPL::Exception;

__PACKAGE__->mk_accessors(
    qw(
        name
        access
        class
        implementor
        attributes
    )
);
__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    die new IMPL::Exception('The name is required for the member') unless $this->name;
    die new IMPL::Exception('The class is required for the member') unless $this->class;
    
    $this->attributes({}) unless defined $this->attributes;
    $this->access(3) unless $this->access;
}

sub Implement {
    my ($this) = @_;
    $this->implementor->Make($this);
    $this->class->set_meta($this);
    return;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Class::MemberInfo> - информация о члене класса.

=head1 DESCRIPTION

Данный класс является базовым для таких классов как C<IMPL::Class::PropertyInfo>, C<IMPL::Class::MethodInfo> и 
предназначен для хренения метаданных.

Данный класс наследуется от C<IMPL::Object::Accessor> и не содержит в себе метаданных о своих членах.

=head1 MEMBERS

=over

=item C<[get,set] name>

Имя члена.

=item C<[get,set] access>

Default public.

Атрибут доступа ( public | private | protected )

=item C<[get,set] class>

Класс владелец
        
=item C<[get,set] attributes>

Дополнительные атрибуты

=item C<Implement()>

При реализации собственного субкласса, данный метод может быть переопределен для
реализации дополнительной обработки (например, создание методов доступа для свойств).

=back

=cut
