package IMPL::Class::Member;
use strict;
use parent qw(Exporter);
our @EXPORT = qw(&public &private &protected);


use IMPL::Const qw(:access);

require IMPL::Class::MemberInfo;

sub public($) {
	my $info = shift;
    $info->{access} = ACCESS_PUBLIC;
    my ($class,$implementor) = delete $info->{'class','-implementor'};
    $class->$implementor($info);
}

sub private($) {
    my $info = shift;
    $info->{access} = ACCESS_PRIVATE;
    my ($class,$implementor) = delete $info->{'class','-implementor'};
    $class->$implementor($info);
}

sub protected($) {
    my $info = shift;
    $info->{access} = ACCESS_PROTECTED;
    my ($class,$implementor) = delete $info->{'class','-implementor'};
    $class->$implementor($info);
}

1;
