package IMPL::Code::DirectPropertyImplementor;
use strict;

use IMPL::require {
	Exception => 'IMPL::Exception',
	ArgException => '-IMPL::InvalidArgumentException'
};

use parent qw(IMPL::Code::BasePropertyImplementor);

use constant {
	CodeGetAccessor => 'return ($this->{$field});',
	CodeSetAccessor => 'return ($this->{$field} = $_[0])',
	CodeGetListAccessor => 'return(
        wantarray ?
        @{ $this->{$field} ?
            $this->{$field} :
            ( $this->{$field} = IMPL::Object::List->new() )
        } :
        ( $this->{$field} ?
            $this->{$field} :
            ( $this->{$field} = IMPL::Object::List->new() )
        )
    );',
    CodeSetListAccessor => 'return(
        wantarray ?
        @{ $this->{$field} = IMPL::Object::List->new(
            (@_ == 1 and UNIVERSAL::isa($_[0], \'ARRAY\') ) ? $_[0] : [@_]  
        )} : 
        ($this->{$field} = IMPL::Object::List->new(
            (@_ == 1 and UNIVERSAL::isa($_[0], \'ARRAY\') ) ? $_[0] : [@_]  
        ))
    );'
};

sub factoryParams { qw($class $name $set $get $validator $field) };

my %cache;

sub Implement {
	my ($self, $spec) = @_;
	
	my $name = $spec->{name}
        or ArgException->new(name => "The name of the property is required");
    my $class = $spec->{class}
        or ArgException->new(name => "The onwer class must be specified");
	
	$spec = $self->NormalizeSpecification($spec);
	
	my $id = $self->CreateFactoryId($spec);
	my $factory = $cache{$id};
	unless($factory) {
        $factory = $self->CreateFactory($spec);
        $cache{$id} = $factory;		
	}
	
	
	
	
}

1;