use strict;
use warnings;
package IMPL::SQL::Schema::Type;

use parent qw(IMPL::Object IMPL::Object::Autofill);

use IMPL::lang qw( :declare :constants :compare );

use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property name => PROP_GET;
    public _direct property maxLength => PROP_GET;
    public _direct property scale => PROP_GET;
    public _direct property unsigned => PROP_GET;
    public _direct property zerofill => PROP_GET;
    public _direct property tag => PROP_GET;
}

__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    $this->{$scale} = 0 if not $this->{$scale};
}

sub SameValue {
    my ($this,$other) = @_;
    
    return (
    	$this->{$name} eq $other->name
    	and equals($this->{$maxLength},$other->{$maxLength})
    	and equals($this->{$scale},$other->{$scale})
    );
}

1;

__END__

=pod

=head1 NAME

C<IMPL::SQL::Schema::Type>  SQL  

=head1 SYNOPSIS

=begin code

use IMPL::SQL::Schema::Type;

my $varchar_t = new IMPL::SQL::Schema::Type( name => 'varchar', maxLength => 255 );

my $real_t = new IMPL::SQL::Schema::Type( name => 'float', maxLength=> 10, scale => 4); # mysql: float(10,4)

=end

      SQL  .  
          . 

=head1 MEMBERS

=over

=item C<CTOR(%props)>

,        .

=item C<[get]name>

 . .

=item C<[get]maxLength>

 ,    ,   ( ,
 ).

=item C<[get]scale>

,    .    C<maxLength>.

=item C<[get]unsigned>

   ,   .

=item C<[get]zerofill>

       C<maxLength>.

=item C<[get]tag>

   .

=back

=cut