package IMPL::DOM::Navigator::Builder;
use strict;
use warnings;

use base qw(IMPL::DOM::Navigator);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
    protected _direct property _navigatorSchema => prop_all;
    public _direct property Document => prop_get | owner_set;
}

__PACKAGE__->PassThroughArgs;

sub CTOR {
    my ($this,$domDocument,$schema) = @_;
    
    $this->{$Document} = $domDocument;
    $this->{$_navigatorSchema} = new IMPL::DOM::Navigator($schema);
}

sub NavigateCreate {
    my ($this,$nodeName,%props) = @_;
    
    if ( my $nodeSchema = $this->{$_navigatorSchema}->Navigate(sub { $_[0]->nodeName eq $nodeName or $_[0]->isa('IMPL::DOM::Schema::AnyNode') }) ) {
        my $class = $nodeSchema->type;
        
        my $node = $this->{$Document}->Create($nodeName, $class, \%props);
        
        $this->Current()->appendNode($node);
        $this->Current($node);
        
    } else {
        die new IMPL::InvalidOperationException("Requested elemnt not found in the schema");
    }
}

1;
