package Test::Web::AutoLocator;
use strict;

use IMPL::Test qw(test assert);
use URI();

use IMPL::declare {
	require => {
		'Locator' => 'IMPL::Web::AutoLocator'
	},
	base => {
		'IMPL::Test::Unit' => '@_'
	}
};

test TestCreation => sub {
	my $location = Locator->new(base => 'http://bugs.company.org', view => "cgi");
	
	my $url = $location->show_bug({id => 100});
	assert( $url->url eq "http://bugs.company.org/show_bug.cgi?id=100", $url->url );
	
	$url = $location->SetView(undef)->help->CreateBug->HowTo;
	assert( $url->url eq "http://bugs.company.org/help/CreateBug/HowTo", $url->url );
};

1;