package IMPL::Web::View::TTControl;
use strict;

use IMPL::Const qw(:prop);
use IMPL::lang qw(:hash :base);
use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		ArgException => '-IMPL::InvalidArgumentException'
	},
	base => [
	   'IMPL::Object' => undef
	],
	props => [
		context => PROP_RO,
		template => PROP_RO,
		_stash => PROP_RO,
		id => {
	   		get => sub { shift->_stash->get('id') },
	   		set => sub { shift->_stash->set('id',shift) }
		}
	]
};


{
    my $nextId = 1;
    sub _GetNextId {
        return '_' . $nextId++;
    }
}

our $AUTOLOAD_REGEX = qr/^[a-z]/;

sub CTOR {
    my ($this,$context,$template) = @_;
    
    $this->context($context)
    	or die ArgException->new(context => 'A context is required');
    $this->template($template)
    	or die ArgException->new(template => 'A template is required');
    	
    $this->_stash($context->stash);
}

sub Render {
	my ($this,$args) = @_;
	return $this->context->include($this->template,$args);
}

our $AUTOLOAD;
sub AUTOLOAD {
	my ($prop) = ($AUTOLOAD =~ m/(\w+)$/);
	
	die Exception->new("Control doesn't have method '$prop'") unless $prop=~/$AUTOLOAD_REGEX/;
	
	no strict 'refs';
	
	my $method = sub {
		if (@_ == 1) {
			return shift->_stash->get($prop);
		} elsif (@_ == 2) {
			return shift->_stash->set($prop,shift);
		} else {
			return shift->_stash->get([$prop,[@_]]);
		}
	};
	
	*{$AUTOLOAD} = $method;
	
	goto &$method;
}


1;

__END__

=pod

=head1 NAME

C<IMPL::Web::View::TTControl> расширяет функциональность шаблонов

=head1 SYNPOSIS

=begin code

package My::View::Menu;
use IMPL::declare {
	base => [
		'IMPL::Web::View::TTControl' => '@_'
	]
};

sub Render {
	my ($this,$args) = @_;
	
	$this->PrepareItems($args);
	
	return $this->next::method($args);
}

sub PrepareItems

=end code

=head1 DESCRIPTION


=cut