package Test::Object::List;
use strict;
use warnings;

use parent qw(IMPL::Test::Unit);
use IMPL::Test qw(test cmparray failed);
use IMPL::Object::List;
__PACKAGE__->PassThroughArgs;

test Creation => sub {
    my $list = new IMPL::Object::List();
    
    failed "Failed to create an empty list" unless $list;
};

test FilledByRef => sub {
    my $data = [map rand 100, 1 .. 300];
    my $list = new IMPL::Object::List($data);
    
    failed("List filled incorrectlty") unless cmparray($data,$list);
};

test FilledByWrongRef => sub {
    eval {
        my $list = new IMPL::Object::List({});
    };
    unless ($@) {
        failed("List can be initialized only by an ARRAY reference");
    }
};

1;
