package IMPL::Web::Handler::ErrorHandler;
use strict;

use IMPL::lang qw(:declare :constants is);
use IMPL::Exception();
use IMPL::declare {
	require => {
		WebException => 'IMPL::Web::Exception',
		ArgumentException => '-IMPL::InvalidArgumentException',
	},
	base => {
		'IMPL::Object' => undef,
		'IMPL::Object::Autofill' => '@_',
		'IMPL::Object::Serializable' => undef
	}
};

BEGIN {
	public property errors => PROP_ALL;
	public property loader => PROP_ALL;
	public property fallback => PROP_ALL;
	public property contentType => PROP_ALL;
}

sub CTOR {
	my ($this) = @_;
	
	die ArgumentException->new("loader") unless $this->loader;
	die ArgumentException->new("fallback") unless $this->fallback;
	
	$this->errors({}) unless $this->errors;
	
}

sub Invoke {
	my ($this,$action,$next) = @_;
	
	undef $@;
	my $result;
	eval {
        $result = $next ? $next->($action) : undef;
	};
	
	if (my $err = $@) {
		$action->ReinitResponse();
		$action->response->charset('utf-8');
		$action->response->contentType($this->contentType);
		
		my $vars = {
			error => $err
		};
		
		my $code = 500;
		
		$code =  $err->code if eval { $err->isa(WebException) };
		
		$action->response->status("$code");
	
		my $doc = $this->loader->document(
            $this->errors->{$code} || $this->fallback,
            $vars
        );
        
        my $hout = $action->response->streamBody;
        print $hout $doc->Render($vars);
	}
	
	return $result;
}

1;