package IMPL::Web::AutoLocator;
use strict;

use IMPL::lang qw(:declare :constants :hash);
use URI;
use URI::Escape;
use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		ArgumentException => '-IMPL::InvalidArgumentException'
	},
	base => [
        'IMPL::Object' => undef,
        'IMPL::Object::Autofill' => '@_',
        'IMPL::Object::Serializable' => '@_'
	]
};

BEGIN {
	public property base => PROP_GET | PROP_OWNERSET;
	public property view => PROP_ALL;
	public property query => PROP_ALL;
	public property hash => RPOP_ALL;
}

sub fetch {
	my $this = shift;
	my $child = shift or die ArgumentException->new(child => "a child resource identifier is required");
	die ArgumentException->new(child => "a child resource can't be a reference");
	
	# safe
	$child = uri_escape($child);
	
	my %args;
	
	$args{base} = $this->base =~ /\/$/ ? $this->base . $child : $this->base . '/' . $child;
	$args{view} = $this->view if $this->view;
	$args{hash} = $this->hash if $this->hash;
	
	if (@_) {
		my $query = shift;
		
		$args{query} = ref $query eq 'HASH' ? hashMerge($this->query,$query) : $query;
	}
	
	return __PACKAGE__->new()
}



1;

__END__

=head1 NAME

=head1 SYNOPSIS

C<IMPL::Web::AutoLocator> - Обертка вокруг адреса ресурса.

=begin code

use IMPL::require {
	Locator => 'IMPL::Web::Locator'
};

my $bugTracker = Locator->new("http://myhost.org/bugzilla")->view("cgi");

my $bug = $bugTracker->show_bug({id = 1});

my $wikiPages = Locator->new("http://myhost.org/wiki/bin/view");

my $page = $wiki->Main->HowTo;

=end code

=head1 DESCRIPTION

Для удобстав навигации по ресурсам, полностью отражает классическую структуру иерархически
организованных ресурсов. позволяет гибко работать с параметрами запроса и хешем. Для постоты
чтения реализует метод C<AUTOLOAD> для доступа к дочерним ресурсам