package IMPL::Web::Handler::RestController;
use strict;

use IMPL::lang qw(:declare :constants);

use IMPL::declare {
	require => {
        NotFoundException => 'IMPL::Web::NotFoundException'
	},
	base => {
		'IMPL::Object' => undef,
	}	
};

BEGIN {
	public property rootResource => PROP_GET | PROP_OWNERSET;
	public property contract => PROP_GET | PROP_OWNERSET;
}

sub Invoke {
	my ($this,$action) = @_;
	
	my $query = $action->query;
	
	my $method = $query->request_method;
	
	#TODO: path_info is broken for IIS
	my $pathInfo = $query->path_info;
	
	my @segments = split /\//, $pathInfo;
	
	my ($obj,$view) = (pop(@segments) =~ m/(.*?)(?:\.(\w+))?$/);
	
	$action->context->{view} = $view;
	
	my $res = $this->rootResource;
	
	while(@segments) {
		$res = $res->InvokeHttpMethod('GET',shift @segments);
		
		die NotFoundException->new() unless $res;
	}
	
	return $res->InvokeHttpMethod($method,$obj);
}

1;

__END__

=pod

=head1 NAME

=head1 SYNOPSIS

=head1 DESCRIPTION

Использует C<$ENV{PATH_INFO}> для получения ресурса и вызова метода.


=cut