package IMPL::Web::QueryHandler;

use parent qw(IMPL::Object IMPL::Object::Autofill IMPL::Object::Serializable);
use IMPL::Class::Property;

__PACKAGE__->PassThroughArgs;

use IMPL::Exception;

sub Invoke {
	my ($self,$action,$nextHandler) = @_;
	
	if (not ref $self) {
		return $self->new( action => $action )->Invoke($action,$nextHandler);
	} else {
		return $self->Process($action,$nextHandler);
	}
}

sub Process {
	die new IMPL::NotImplementedException("The method isn't implemented", __PACKAGE__, 'Process');
}

1;

__END__

=pod

=head1 NAME

Базовый класс для обработчиков запросов.

=head1 SYNOPSIS

Простой вариант

=begin code

package MyHandler;

use parent qw(IMPL::Web::QueryHandler);

sub CTOR {
	my ($this,%args) = @_;
	
}

sub Process {
	my ($this,$action,$nextHandler) = @_;
	
}

=end code

=head1 MEMBERS

=over 4

=item C< Invoke($action,$nextHandler) >

Вызывается механизмом обработки запроса, для передачи управления обработчику. Данная реализация
проверяет контекст вызова, если как статический метод, то создает экземпляр класса и вызывает
у созданного объекта метод C< Invoke > с параметрами C< $action >, C< $nextHandler >.

При создании нового объекта в конструктор передается именованый параметр C<action>. 

Если метод был вызван у объекта, то управление передается методу C< Process >.

=over

=item C< $action >

Экземпляр запроса

=item C< $nextHandler >

Делегат для вызова следующего обработчика. Вызывается без параметров, но следующему обработчику
втоматически будут переданы необходимые параметры.

=back

=back

=cut
