package IMPL::Web::View::TTControl;
use strict;

use IMPL::DOM::Property qw(_dom);
use IMPL::lang qw(:declare :constants);

use Template::Context();

use parent qw(
	IMPL::DOM::Node
);

my $nextId = 1;


BEGIN {
	public _dom property id => PROP_ALL;
	
	public property context => PROP_GET | PROP_OWNERSET;
	public property template => PROP_ALL;
}


sub CTOR {
	my ($this,$name,$template,$context,$refProps) = @_;
	
	$this->template( $template ) or die new IMPL::ArgumentException("A template is required");
	$this->context( $context ) or die new IMPL::ArgumentException("A context is required");
	
	if ( my $ctor = $template->blocks->{CTOR} ) {
		$context->process($ctor, { this => $this } );
	}
	
}

our %CTOR = (
	'IMPL::DOM::Node' => sub {
		nodeName => $_[0],
		%{ $_[3] || {} }
	}
);

sub Render {
	my ($this) = @_;
	
	if(my $body = $this->template->blocks->{RENDER} ) {
		return $this->context->process( $body, { this => $this } );
	} else {
		return "";
	}	
}

sub AUTOLOAD {
	our $AUTOLOAD;
	
	my $method = ($AUTOLOAD =~ m/(\w+)$/)[0];
	
	return if $method eq 'DESTROY';
	
	my $res = $_[0]->template->$method();
	
	return defined($res) ? $res : $_[0]->context->stash->get($method); 
	
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::View::TTControl>

=head1 SYNPOSIS

=head1 DESCRIPTION

=head2 BLOCKS

При загрузке шаблона, создается фабрика, с собственным контекстом в которой выполняется шаблон элемента управления

=head3 INIT

Данный блок шаблона управления выполняется один раз при создании первого экземпляра элемента управления

=head3 CTOR

данный блок выполняется каждый раз при создании нового экземпляра элемента управления, при этом переменная C<this>
указывает на эземпляр элемента упарвления

=head3 RENDER

 


C<lang ru>

=cut