package Security::Authz;
use Common;
use Security;

our @ISA = qw(Object);

BEGIN {
    DeclareProperty User => ACCESS_READ;
}

sub _CurrentUser {
    my ($class) = @_;

    if (ref $class) {
        return $class->{$User};
    } else {
        if (Security->CurrentSession) {
            Security->CurrentSession->User;
        } else {
            return undef;
        }
    }
}

sub demand {
    my ($class,@Roles) = @_;

    return 0 if not $class->_CurrentUser;

    my %UserRoles = map { $_->Name, 1 } $class->_CurrentUser->Roles;

    return not grep {not $UserRoles{$_}} @Roles;
}