package IMPL::Web::Security;
use strict;

use IMPL::Security::Auth qw(:Const);
use IMPL::declare {
    require => {
        Exception => 'IMPL::Exception',
        NotImplementedException => '-IMPL::NotImplementedException',
        SecurityContext => 'IMPL::Security::AbstractContext'
    },
};

sub AuthUser {
    my ($this,$name,$package,$challenge) = @_;
    
    my $user = $this->FindUserByName($name)
        or return { status => AUTH_FAIL, answer => "Can't find a user '$name'" };
    
    my $auth;
    if ( my $secData = $user->GetSecData($package) ) {
        $auth = $package->new($secData);
    } else {
        return {
            status => AUTH_FAIL,
            user => $user
        };
    }
    
    my ($status,$answer) = $auth->DoAuth($challenge);
    
    if ($status != AUTH_FAIL) {
        SecurityContext->current->authority->CreateContext(
            $user,
            $auth,
            [$user->roles],
            $answer,
            $this
        );
    }
    
    return {
        status => $status,
        user => $user
    };
}

sub FindUserByName {
    die NotImplementedException->new();
}

sub CreateSession {
    die NotImplementedException->new();
}

sub GetSession {
    die NotImplementedException->new();
}

sub SaveSession {
    die NotImplementedException->new();
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Security> Модуль для аутентификации и авторизации веб запроса.

=head1 SINOPSYS

=begin code xml

<security type='IMPL::Config::Activator'>
    <factory>IMPL::Web::Security</factory>
    <parameters type='HASH'>
        <sessionFactory type='IMPL::Object::Factory'>
            <factory type='IMPL::Object::Factory'>App::Data::Session</factory>
            <method>insert</method>
        </sessionFactory>
    </parameters>
</security>

=end code xml

=head1 DESCRIPTION

Отвечает за инфраструктуру аутентификации и авторизации запросов. Основная особенность
заключается в том, что запросы приходят через значительные интевалы времени, хотя и
относятся к одной логической транзакции. В промежутках между запросами сервер не
сохраняет свое состояние. Поэтому при каждом обращении сервер восстанавливает
контекст безопасности.

C<IMPL::Web::Security::Session> Объект обеспечивающий сохранение состояния в рамках одной сессии
пользователя. Кроме контекста безопасности хранит дополнительние данные, которые необходимо
сохранить между обработкой запросов.

C<IMPL::Web::Security::User> Объект, устанавливающий связь между идентификатором пользователя
C<IMPL::Security::Principal>, его ролями и данными безопасности для создания объектов
аутентификации C<IMPL::Security::Auth>.

=head1 MEMBERS

=cut
