package IMPL::Class::MemberInfo;
use strict;
use base qw(IMPL::Object::Accessor);

require IMPL::Exception;
require IMPL::Class::Member;

__PACKAGE__->mk_accessors(
    qw(
        Name
        Access
        Virtual
        Class
        Frozen
        Implementor
        Attributes
    )
);
__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    die new IMPL::Exception('The name is required for the member') unless $this->Name;
    die new IMPL::Exception('The class is required for the member') unless $this->Class;
    
    $this->Attributes({}) unless defined $this->Attributes;
    $this->Frozen(0);
    $this->Virtual(0) unless defined $this->Virtual;
    $this->Access(3) unless $this->Access;
}

sub Implement {
    my ($this) = @_;
    $this->Implementor->Make($this);
    $this->Frozen(1);
    $this->Class->set_meta($this);
    return;
}

sub set {
    my $this = shift;
    if ($this->Frozen) {
        die new IMPL::Exception('The member information is frozen', $this->Name);
    }
    $this->SUPER::set(@_);
}

1;
