package IMPL::Web::QueryHandler::SecureCall;
use strict;
use base qw(IMPL::Web::QueryHandler);

use IMPL::Class::Property;
use IMPL::Exception;
use Carp;

BEGIN {
	public property namespace => prop_all;
}

__PACKAGE__->PassThroughArgs;

sub Process {
	my ($this,$action,$nextHandler) = @_;
	
	my $namespace = $this->namespace || $action->application->type;
	
	my @target = grep $_, split /\//, ($ENV{PATH_INFO} || '') or die new IMPL::Exception("No target specified");
	
	my $method = pop @target;
	$method =~ s/\.\w+$//;
	
	my $module = join '::',$namespace,@target;
	
	eval "require $module; 1;";
	carp $@ if $@;
	
	if(UNIVERSAL::can($module,'InvokeAction')) {
		$module->InvokeAction($method,$action);
	} else {
		die new IMPL::InvalidOperationException("Failed to invoke action",$ENV{PATH_INFO},$module,$method);
	}
}

1;