package Configuration;
our $DataDir;
package DOM::Providers::Form;
use strict;
use Form;
use Schema::Form;
use Common;
our @ISA = qw(Object);

our $Encoding ;
our $CacheDir ||= "${DataDir}Cache/";
warn "The encoding for the DOM::Provider::Form isn't specified" if not $Encoding;
$Encoding ||= 'utf-8';

sub GetProviderInfo {
    return {
        Name => 'Form',
        Host => 'DOM::Site',
        Methods => {
            LoadForm => \&SiteLoadForm
        }
    }
}

BEGIN {
    DeclareProperty FormsEncoding => ACCESS_READ;
    DeclareProperty DataCacheDir => ACCESS_READ;
}

sub SiteLoadForm {
    my ($this,$site,$file,$form) = @_;
    return $site->RegisterObject('Form',$this->LoadForm($file,$form));
}

sub LoadForm {
    my ($this,$file, $formName) = @_;
    
    my $formSchema = Schema::Form->LoadForms($file,$this->{$DataCacheDir},$this->{$FormsEncoding})->{$formName} or die new Exception('The form isn\'t found',$formName,$file);
    return Form->new($formSchema);
}

sub construct {
    my ($class) = @_;
    
    return $class->new(FormsEncoding => $Encoding, DataCacheDir => $CacheDir);
}


1;
