package Test::ORM::Schema;
use strict;
use warnings;
use base qw(IMPL::Test::Unit);

require IMPL::SQL::Schema::Traits::mysql;

__PACKAGE__->PassThroughArgs;

use IMPL::Test qw(test failed);

require IMPL::ORM::Schema::TransformToSQL;

test ExtractClassSchema => sub {
    my ($this) = @_;
    
    my $schema = Test::ORM::Schema::Data::User->ormGetSchema('Test::ORM::Schema::Data');
    failed "Wrong number of the elements","expected: 4","got: ".$schema->childNodes->Count unless $schema->childNodes->Count == 4;
    
    return 1;
};

test StaticSchema => sub {
    my ($this) = @_;
    
    my $schema = Test::ORM::Schema::Data->instance;
    
    return 1;
};

test GenerateSQL => sub {
    my $sqlSchema = IMPL::ORM::Schema::TransformToSQL->Std->Transform(Test::ORM::Schema::Data->instance)
        or failed("Failed to transform a schema");
        
    my $sqlEmpty = new IMPL::SQL::Schema(Name => 'empty');
    
    my $traits = IMPL::SQL::Schema::Traits::mysql->new(
        SrcSchema => $sqlEmpty,
        DstSchema => $sqlSchema
    );
    
    $traits->UpdateSchema();
    
    print "$_\n" foreach $traits->Handler->Sql;
    
    $sqlEmpty->Dispose;
    $sqlSchema->Dispose;
};


package Test::ORM::Schema::Data::User;
use base qw(IMPL::ORM::Object);
use IMPL::Class::Property;

BEGIN {
    public property Name => prop_all, { type => 'String' }; # Field
    public property Id => prop_all, { type => 'String' }; # Field
    public property Roles => prop_all | prop_list, { type=> 'Test::ORM::Schema::Data::Role'}; # HasMany
}

package Test::ORM::Schema::Data::Role;
use base qw(IMPL::ORM::Object);
use IMPL::Class::Property;

BEGIN {
    public property Name => prop_all, { type => 'String' }; # Field
}

package Test::ORM::Schema::Data::Session;
use base qw(IMPL::ORM::Object);
use IMPL::Class::Property;
use IMPL::ORM::Helpers qw(Map);

BEGIN {
    public property Id => prop_get, { type => 'String' }; # Field
    public property User => prop_get, { type => 'Test::ORM::Schema::Data::User' }; # HasOne
    #public property Data => prop_all, { type => Map( 'String','String' ) }; # HasOne
    public property AccessTime => prop_get, { type => 'DateTime' }; # Field
}

package Test::ORM::Schema::Data;
use base qw(IMPL::ORM::Schema);

__PACKAGE__->ValueTypes (
    String => 'IMPL::ORM::Value::String',
    DateTime => 'IMPL::ORM::Value::DateTime',
    Integer => 'IMPL::ORM::Value::Inetger',
    Float => 'IMPL::ORM::Value::Float',
    Decimal => 'IMPL::ORM::Value::Decimal'
);

__PACKAGE__->usePrefix(__PACKAGE__);
__PACKAGE__->Classes qw(
    User
    Role
    Session
);

__PACKAGE__->CompleteSchema;

1;
