package IMPL::Security::Role;
use strict;

use IMPL::require {
    AbstractRole => 'IMPL::Security::AbstractRole'    
};

use IMPL::declare {
    base => [
        'IMPL::Object' => undef,
        'IMPL::Security::AbstractRole' => undef 
    ],
    _implement => 1
};

sub CTOR {
    my ($this,$name,$parentRoles) = @_;
    
    $this->roleName($name) if $name;
    $this->parentRoles($parentRoles) if $parentRoles;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Role> - стандартная реализация роли безопасности.

=head1 SYNOPSIS

=begin code

# create the megarole
my $role = IMPL::Security::Role->new(megarole => [ $adminRole, $directorRole ] );

#use it in context
my $context = IMPL::Security::Context->new(
    principal => $user,
    assignedRoles => [$user->roles, $megarole]
);

$context->Impersonate( sub {
    # do something forbidden
});

=end code

=head1 DESCRIPTION

Позволяет создавать объекты ролей без привязки к источникам данных и модулям
авторизации. Чаще всего используется при реализации каких либо механизмов
безопасности, где требуется создать временную роль.

C<IMPL::Security::AbstractRole>

=cut