#!/usr/bin/perl
use strict;

{
    package Foo;
    use IMPL::declare {
        base => [
            'IMPL::Object::Disposable' => undef
        ]
    };
}

use Time::HiRes qw(gettimeofday tv_interval);


use IMPL::lang;
use IMPL::require {
    AutoDispose => 'IMPL::Object::AutoDispose',
    DBSchema => 'IMPL::SQL::Schema'    
};

my $real = DBSchema->new( name => 'simple', version => 1);
my $proxy = AutoDispose->new($real);

print typeof($proxy),"\n";

my $t = [gettimeofday];

for (1..1000000) {
    $proxy->name;
}

print "proxy: ",tv_interval($t,[gettimeofday]),"\n";

$t = [gettimeofday];

for (1..1000000) {
    $real->name;
}

print "real:  ",tv_interval($t,[gettimeofday]),"\n";
   
