package IMPL::Web::Application::ResourceContract;
use strict;
use IMPL::lang qw(:declare);
use IMPL::declare {
	require => {
		'ResourceClass' => 'IMPL::Web::Application::Resource'
	},
	base => [
	   'IMPL::Object' => undef
	]
};

BEGIN {
	public property resourceFactory => PROP_ALL;
	public property operations => PROP_ALL;
	private property _namedResources => PROP_ALL;
	private property _regexpResources => PROP_ALL; 
}

sub CTOR {
	my $this = shift;
	my %args = @_;
	
	$this->resourceFactory( $args{resourceFactory} || ResourceClass );
}

sub CreateResource {
	my ($this,)
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Application::ResourceContract> - описание ресурса

=head1 SYNIOSIS

=begin code

use IMPL::require {
	ResourceContract => 'IMPL::Web::Application::ResourceContract',
	OperationContract => 'IMPL::Web::Application::OperationContract'
};

my $contract = ResourceContract->new(
    operations => {
    	get => OperationContract->new(
            bind => sub {
                return "Hello!";
            }
        )
    },
    resources => [
        {
        	name => 'info',
        	bind => sub {
        		return $_[0]->model->info;
        	},
        	contract => ResourceContract->new(
        	   get => OperationContract->new(
        	       bind => sub {
        	       	   my ($resource,$model) = @_;
        	       	   return $model; # or the same: $resource->model;
        	       }
        	   )
        	)
        }
    ]
)

my $obj = My::App::Data->fetch('something');

my $resource = $contract->CreateResource(
    model => $obj,
    parent => $prentResource,
    id => 'item-something'
);

=end code 

=head1 DESCRIPTION

=cut