package IMPL::Web::NotAllowedException;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
    base => [
        'IMPL::Web::Exception' => '@_'
    ]
};

use IMPL::Resources::Strings {
    message => "The requested method isn't allowed"
};

sub CTOR {
    my $this = shift;
    my %args = @_;
    
    $this->headers({
       allow => $args{allow} 
    });
}

sub status {
    "405 Method Not Allowed"
}

1;

__END__