package IMPL::Security::Context;
use strict;
use warnings;

use base qw(IMPL::Object);

use IMPL::Class::Property;

require IMPL::Security::Principal;

my $current;
my $nobody;

BEGIN {
    public property principal => prop_get;
    public property rolesAssigned => prop_all | prop_list;
    public property auth => prop_all;
}

sub Impersonate {
    my ($this,$code) = @_;
    
    my $old = $current;
    my $result;
    local $@;
    eval {
        $result = $code->();
    };
    $current = $old;
    if($@) {
        die $@;
    } else {
        return $result;
    }
}

sub contextNobody {
    my ($self) = @_;
    $nobody = $self->new(principal => IMPL::Security::Principal->nobody, rolesAssigned => undef) unless $nobody;
    $nobody;
}

sub contextCurrent {
	my ($self) = @_;
	
	$current = __PACKAGE__->nobody unless $current;
	$current;
}

1;
