package Test::Web::View;
use strict;
use warnings;

use parent qw(IMPL::Test::Unit);
__PACKAGE__->PassThroughArgs;

use IMPL::Test qw(assert test);
use IMPL::Web::View::TTLoader();

use constant {
	TTLoader => typeof IMPL::Web::View::TTLoader
};

test TemplateLoaderTests => sub {
	my ($this) = @_;
	
	my $loader = TTLoader->new(
		{
			INCLUDE_PATH => [
				$this->GetResourceDir('Resources','TTView')
			]
		},
		ext => '.tt',
		initializer => 'global.tt'
	);
	
	# test the loader to be able to find a desired resource
	assert( defined($loader->template('simple') ) );
	
	# loader should be initialized on demand
	assert( not $loader->isInitialized );
	
	# loader should be able to load a document
	my $doc = $loader->document('simple');
	assert(defined $doc);
	
	assert( $loader->isInitialized );
	assert( $loader->context->stash->get('user') eq 'test_user');
	
	# document should inherit loader's context 
	assert( $doc->context->stash->get('user') eq 'test_user');
};

1;