package IMPL::Web::View::TTView;
use strict;

use JSON;
use IMPL::lang qw(hashMerge is);
use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		Context => 'IMPL::Web::View::TTContext',
		Loader  => 'IMPL::Code::Loader',
		Factory => 'IMPL::Web::View::ObjectFactory'
	},
	base => [
		'IMPL::Object' => undef,
		'IMPL::Object::Autofill' => '@_',
		'IMPL::Object::Serializable' => undef
	],
	props => [
		options => PROP_RW,
		viewBase => PROP_RW,
		layoutBase => PROP_RW,
		layout => PROP_RW,
		tt_ext => PROP_RW,
		includes => PROP_RW | PROP_LIST,
		globals => PROP_RW
	]
};

sub CTOR {
	my ($this) = @_;
	
	$this->tt_ext('tt') unless defined $this->tt_ext;
}

sub display {
	my ($this,$model,$template,$args) = @_;
	
	my $context = Context->new($this->options);
	eval {
		warn $context->process('globals' . '.' . $this->tt_ext, $args);
	};
	my $layout = delete $args->{layout} || $this->layout;
	
	return $context->invoke_environment(
		sub {
			my $ctx = shift;
			if ($layout) {
				return $ctx->invoke_environment(
					sub {
						return shift->render(
							$layout,
							hashMerge(
								{
									content => sub {
										$ctx->invoke_environment(
											sub {
												return shift->display_model($model,$template);
											},
											{
												base => $this->viewBase
											}
										)
									},
									model => $model
								}
							)
						); # render
					},
					{
						base => $this->layoutBase,
					}
				);
			} else {
				return $ctx->invoke_environment(
					sub {
						return shift->display_model($model,$template);
					},
					{
						base => $this->viewBase
					}
				);
			}
		},hashMerge(
			$this->globals,
			hashMerge(
				$args,
				{
					includes => scalar($this->includes),
					tt_ext => $this->tt_ext,
					debug => sub {
						warn @_;
					},
					is => sub {
						my ($obj,$class) = @_;
						if (is($class,Factory)) {
							return is($obj,$class->factory);
						} else {
							return is($obj,$class);
						}
					},
					import => sub {
						return Factory->new(Loader->safe->Require(shift));
					},
					toJSON => sub {
						return JSON->new()->utf8->pretty->encode(shift);
					}
				}
			)
		)
	);
}

1;