package IMPL::DOM::Schema::Label;
use strict;
use overload
	'""' => 'ToString',
    'bool'     =>   sub { return 1; },
    'fallback' => 1;

use IMPL::Const qw(:prop);
use IMPL::Exception();
use IMPL::declare {
	require => {
		ArgException => '-IMPL::InvalidArgumentException'
	},
	base => [
		'IMPL::Object' => undef
	],
	props => [
		_map => PROP_RW,
		_id => PROP_RW
	]
};

sub CTOR {
	my ($this,$map,$id) = @_;
	
	die ArgException->new('map' => 'A strings map is required')
		unless $map;
	die ArgException->new('id' => 'A lable identifier is required')
		unless $id;
		
	$this->_map($map);
	$this->_id($id);
}

our $AUTOLOAD;
sub AUTOLOAD {
	my ($this) = @_;
	
	my ($method) = ($AUTOLOAD =~ /(\w+)$/);
	return
		if $method eq 'DESTROY';
		
	warn $this->_id . ".$method";
		
	return $this->new($this->_map,$this->_id . ".$method");
}

sub ToString {
	my ($this) = @_;
	return $this->_map->GetString($this->_id);
}

sub Format {
	my ($this,$args) = @_;
	
	return $this->_map->GetString($this->_id,$args);
}

1;