package IMPL::Config::Path;
use strict;
use IMPL::Config();

use IMPL::require {
	Exception => 'IMPL::Exception',
	OpException => '-IMPL::InvalidOperationException'
};

sub restore {
	my ($self,$data,$surrogate) = @_;
	
	die OpException->new("Invalid content") unless ref $data eq 'ARRAY' && @$data == 2;
	
	my ($base,$path) = @$data;
	
	my %types = (
	   appBase => 'AppDir',
	   configBase => 'ConfigDir'
	);
	
	my $method = $types{$base};
	
	die OpException->new("Unsupported path type",$base) unless $method;
	
	return IMPL::Config->$method($path);
}

1;