package IMPL::DOM::Navigator;
use strict;
use warnings;

use base qw(IMPL::Object);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
BEGIN {
    public _direct property Path => prop_get | owner_set;
    public _direct property Current => prop_get | owner_set;
}

sub CTOR {
    my ($this,$CurrentNode) = @_;
    
    $this->{$Current} = $CurrentNode or die IMPL::InvalidArgumentException("A starting node is a required paramater");
}

sub Navigate {
    my ($this,$query) = @_;
    
    if ( my ($newNode) = $this->{$Current}->selectNodes($query) ) {
        push @{$this->{$Path}}, $this->{$Current};
        return $this->{$Current} = $newNode;
    } else {
        return undef;
    }
}

sub Back {
    my ($this) = @_;
    
    if ( my $newNode = $this->{$Path} ? pop @{$this->{$Path}} : undef ) {
        return $this->{$Current} = $newNode;
    } else {
        return undef;
    }
}

sub PathToString {
    my $this = shift;
    
    join('/',map $_->nodeName, $this->{$Path} ? (@{$this->{$Path}}, $this->{$Current}) : $this->{$Current});
}

1;

__END__
=pod

=head1 DESCRIPTION

     DOM .

=head1 METHODS

=over

=item C<$obj->new($nodeStart)>

      .

=item C<$obj->Navigate($query)>

      C<$query>.     
         .     
,    .

      ,  C<undef>.

=item C<$obj->Back()>

   ,   .

     ,  C<undef>.

=back

=cut