package IMPL::DOM::XMLReader;
use strict;
use warnings;

use base qw(IMPL::Object IMPL::Object::Autofill);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
use XML::Parser;

BEGIN {
    public _direct property Navigator => prop_get | owner_set;
    private _direct property _current => prop_all;
}

sub Parse {
    my ($this,$in) = @_;
    
    my $parser = new XML::Parser(
        Handlers => {
            Start => sub {shift; goto &OnStart($this,@_)},
            End => sub {shift; goto &OnEnd($this,@_)},
            Char => sub {shift; goto &OnChar($this,@_)}
        }
    );
    
    $parser->parse($in);
}

sub OnBegin {
    my ($this,$element,%attrs) = @_;
    
    $this->{$_current} = $this->Navigator->NavigateCreate($element,%attrs);
}

sub OnEnd {
    my ($this,$element) = @_;
    
    $this->{$_current} = $this->Back;
}

sub OnChar {
    my ($this,$val) = @_;
    
    $this->{$_current}->nodeValue($this->{$_current}->nodeValue . $val);
}

1;
