package Form::Filter::Mandatory;
use strict;
use Common;
use base qw(Form::Filter);

sub SUPPORTED_CONTEXT { Form::Filter::CTX_SINGLE | Form::Filter::CTX_SET }

sub Invoke {
    my ($this,$target,$context,$schemaTarget,$parent) = @_;
    
    my @list;
    if ($context & Form::Filter::CTX_SET) {
        @list = @{$target || []};
    } elsif ($context & (Form::Filter::CTX_SINGLE | Form::Filter::CTX_EXISTENT)) {
        @list = ($target);
    }
    
    foreach my $object (@list) {
        if (defined $object and not $object->isEmpty) {
            return Form::FilterResult->new(
                State => Form::FilterResult::STATE_SUCCESS_STAY
            );
        }
    }
    
    return Form::FilterResult->new(
        State => Form::FilterResult::STATE_ERROR,
        Message => $this->FormatMessage($schemaTarget),
        Target => $schemaTarget,
        Container => $parent
    );
}

1;