package Test::DOM::Node;
use strict;
use warnings;

use base qw(IMPL::Test::Unit);
use IMPL::Test qw(test shared failed);
use IMPL::Class::Property;

require IMPL::DOM::Node;

__PACKAGE__->PassThroughArgs;

BEGIN {
    shared public property Root => prop_all;
}

test Create => sub {
    my ($this) = @_;
    
    $this->Root(new IMPL::DOM::Node(nodeName => 'Root')) or failed "Failed to create a node";
};

test AppendNode => sub {
    my ($this) = @_;
    
    my $child = $this->Root->appendNode(new IMPL::DOM::Node(nodeName => 'Child')) or failed "Failed to append a child node";
    
    my $firstChild = $this->Root->firstChild;
    
    failed "firstChild returned incorrect results" unless $firstChild == $child;
};

1;
