package IMPL::DOM::Schema;
use strict;
use warnings;

use base qw(IMPL::DOM::Document);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

__PACKAGE__->PassThroughArgs;

BEGIN {
    private _direct property _TypesMap => prop_all;
}

sub ResoveType {
    $_[0]->{$_TypesMap}->{$_[1]};
}

sub MetaSchema {
    my $schema = new IMPL::DOM::Schema(nodeName => 'schema');
    
    $schema->appendRange(
        IMPL::DOM::Schema::ComplexNode->new(nodeName => 'schema')->appendRange(
            IMPL::DOM::Schema::NodeSet->new()->appendRange(
                IMPL::DOM::Schema::Node->new(nodeName => 'ComplexNode', type => 'ComplexNode', minOccur => 0, maxOccur=>'unbounded'),
                IMPL::DOM::Schema::Node->new(nodeName => 'ComplexType', type => 'ComplexType', minOccur => 0, maxOccur=>'unbounded'),
                IMPL::DOM::Schema::Node->new(nodeName => 'SimpleNode', type => 'SimpleNode', minOccur => 0, maxOccur=>'unbounded'),
                IMPL::DOM::Schema::Node->new(nodeName => 'SimpleType', type => 'SimpleType', minOccur => 0, maxOccur=>'unbounded'),
                IMPL::DOM::Schema::SimpleNode->new(nodeName => 'Node', minOccur => 0, maxOccur=>'unbounded'),
                IMPL::DOM::Schema::SimpleNode->new(nodeName => 'Include', minOccur => 0, maxOccur=>'unbounded')
            )
        ),
        IMPL::DOM::Schema::ComplexType->new(type => 'NodeSet', native => 'IMPL::DOM::Schema::NodeSet')->appendRange(
            IMPL::DOM::Schema::NodeSet->new()->appendRange(
                IMPL::DOM::Schema::Node->new(nodeName => 'ComplexNode', type => 'ComplexNode', minOccur => 0, maxOccur=>'unbounded'),
                IMPL::DOM::Schema::Node->new(nodeName => 'SimpleNode', type => 'SimpleNode', minOccur => 0, maxOccur=>'unbounded'),
                IMPL::DOM::Schema::SimpleNode->new(nodeName => 'Node', minOccur => 0, maxOccur=>'unbounded'),
            )
        )
    )
}

1;

__END__

=pod

=head1 META SCHEMA

   ,       

<schema>
    <ComplexNode nodeName="schema">
        <NodeSet>
            <Node minOcuur="0" maxOccur="unbounded" nodeName="ComplexNode" type="ComplexNode"/>
            <Node minOcuur="0" maxOccur="unbounded" nodeName="SimpleNode" type="SimpleNode"/>
            <Node minOcuur="0" maxOccur="unbounded" nodeName="ComplexType" type="ComplexType"/>
            <Node minOcuur="0" maxOccur="unbounded" nodeName="SimpleType" type="SimpleType"/>
            <SimpleNode minOcuur="0" maxOccur="unbounded" nodeName="Node"/>
            <SimpleNode minOcuur="0" maxOccur="unbounded" nodeName="Include"/>
        </NodeSet>
    </ComplexNode>
    
    <ComplexType type="NodeContainer">
        <NodeSet>
            <Node minOcuur="0" maxOccur="unbounded" nodeName="ComplexNode" type="ComplexNode"/>
            <Node minOcuur="0" maxOccur="unbounded" nodeName="SimpleNode" type="SimpleNode"/>
            <SimpleNode minOcuur="0" maxOccur="unbounded" nodeName="Node"/>
        </NodeSet>
    </ComplexType>
    
    
    <ComplexType type="ComplexType">
        <NodeList>
            <Node nodeName="NodeSet" type="NodeContainer" minOcuur=0/>
            <Node nodeName="NodeList" type="NodeContainer" minOccur=0/>
            <AnyNode minOccur="0" maxOccur="unbounded"/>
        </NodeList>
    </ComplexType>
    
    <ComplexType type="ComplexNode">
        <NodeList>
            <Node nodeName="NodeSet" type="NodeContainer" minOcuur=0/>
            <Node nodeName="NodeList" type="NodeContainer" minOccur=0/>
            <AnyNode minOccur="0" maxOccur="unbounded"/>
        </NodeList>
    </ComplexType>
    
    <ComplexType type="SimpleNode">
        <NodeSet>
            <AnyNode minOccur=0 maxOccur="unbounded"/>
        </NodeSet>
    </ComplexType>
    
    <ComplexType type="SimpleType">
        <NodeSet>
            <AnyNode minOccur=0 maxOccur="unbounded"/>
        </NodeSet>
    </ComplexType>
    
</schema>

=cut
