package IMPL::SQL::Schema::Constraint::PrimaryKey;
use strict;
use base qw(IMPL::SQL::Schema::Constraint::Index);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

__PACKAGE__->PassThroughArgs;

BEGIN {
    public _direct property ConnectedFK => prop_get;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->SUPER::CTOR(%args);
    
    $this->{$ConnectedFK} = {};
}

sub ConnectFK {
    my ($this,$FK) = @_;
    
    UNIVERSAL::isa($FK,'IMPL::SQL::Schema::Constraint::ForeignKey') or die new Exception('Aprimary key could be connected only to a foreign key');
    not exists $this->{$ConnectedFK}->{$FK->UniqName} or die new Exception('This primary key already conneted with the specified foreing key',$FK->Name,$FK->Table->Name);
    
    $this->{$ConnectedFK}->{$FK->UniqName} = $FK;
}

sub DisconnectFK {
    my ($this,$FK) = @_;
    
    delete $this->{$ConnectedFK}->{$FK->UniqName};
}

sub Dispose {
    my ($this) = @_;
    
    delete $this->{$ConnectedFK};
    $this->SUPER::Dispose;
}

1;
