package IMPL::Object::Meta;
use strict;
use warnings;

use base qw(IMPL::Object);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property Container => prop_get | owner_set;
}

sub meta {
    my $class = shift;
    my $caller = caller;
    my $meta = $class->surrogate();
    $meta->IMPL::Object::Meta::Container(caller);
    $meta->callCTOR(@_);
    $caller->set_meta($meta);
}

1;

__END__

=pod

=head1 SYNOPSIS

package Foo;

meta BarAttribute('Simple bar attribute'); #mark Foo with BarAttribute

=head1 DESCRIPTION

   - .   C< meta >      .

=head1 MEMBERS

=over

=item C< Container >

            .

=back

=cut