package IMPL::Web::QueryHandler;

use base qw(IMPL::Object IMPL::Object::Autofill);
use IMPL::Class::Property;

__PACKAGE__->PassThroughArgs;

use IMPL::Exception;

sub Invoke {
	my ($self,$action,$nextHandler) = @_;
	
	if (not ref $self or UNIVERSAL::isa($self,'IMPL::Object::Factory')) {
		return $self->new( action => $action )->Invoke($action,$nextHandler);
	} else {
		return $self->Process($action,$nextHandler);
	}
}

sub Process {
	die new NotImplementedException("The method isn't implemented", __PACKAGE__, 'Process');
}

1;

__END__

=pod

=head1 DESCRIPTION

    .

=head1 MEMBERS

=over 4

=item C< Invoke($action,$nextHandler) >

   ,    .  
   ,    ,      
    C< Invoke >   C< $action >, C< $nextHandler >.

     ,     C< Process >

C< $action >  

C< $nextHandler >     .   ,   
    .

=back

=cut